<?php

class KlasaController extends Controller
{
	public $layout = 'administration';
	public $defaultAction = 'admin';


	public function init()
	{
		Yii::import('application.modules.administration.controllers.MainController');
		$mainController = new MainController('main');
		$this->menu = $mainController->getMenu();
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
			'postOnly + delete',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated users to perform actions
				'actions'=>array('create','update','delete','admin','registrationStart','view'),
				'roles'=>array('admin')
			),
			array('allow', // allow authenticated users to perform actions
				'actions'=>array('create','update','delete','admin','registrationStart','view'),
				'roles'=>array('schoolAdmin')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate($schoolId)
	{
		$model = new Klasa;
		$schoolModel = Szkola::model()->findByPk($schoolId);
		$model->idSzkoly = $schoolId;
		$teachers = Admin::model()->findAll('"idSzkoly"=:idSzkoly AND "rodzaj"=1', array(':idSzkoly'=>$model->idSzkoly));

		if(isset($_POST['Klasa']))
		{
			$model->attributes = $_POST['Klasa'];

			if($model->validate())
			{
				$model->save(false);

				AdminKlasy::model()->deleteAll('"idKlasy" = :idKlasy',array(':idKlasy'=>$model->id));
				if(!empty($model->teacherId))
				{
					$adminKlasyModel = new AdminKlasy();
					$adminKlasyModel->idKlasy = $model->id;
					$adminKlasyModel->idAdmina = $model->teacherId;
					$adminKlasyModel->save(false);
				}

				$this->redirect(array('admin', 'schoolId'=>$model->idSzkoly));
			}
		}

		$this->render('create', array(
			'model'=>$model,
			'schoolModel'=>$schoolModel,
			'teachers'=>$teachers
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);
		$students = Uzytkownik::model()->findAll('"idKlasy"=:idKlasy',array(':idKlasy'=>$id));
		$teachers = Admin::model()->findAll('"idSzkoly"=:idSzkoly AND "rodzaj"=1',array(':idSzkoly'=>$model->idSzkoly));

		if(count($model->admini))
			$model->teacherId = $model->admini[0]->id;
		else
			$model->teacherId = '';

		if(isset($_POST['Klasa']))
		{
			$model->attributes = $_POST['Klasa'];

			if($model->validate())
			{
				$model->save(false);

				AdminKlasy::model()->deleteAll('"idKlasy" = :idKlasy',array(':idKlasy'=>$model->id));
				if(!empty($model->teacherId))
				{
					$adminKlasyModel = new AdminKlasy();
					$adminKlasyModel->idKlasy = $id;
					$adminKlasyModel->idAdmina = $model->teacherId;
					$adminKlasyModel->save(false);
				}

				$this->redirect(array('admin', 'schoolId'=>$model->idSzkoly));
			}
		}

		$this->render('update',array(
			'model'=>$model,
			'students'=>$students,
			'teachers'=>$teachers
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		try
		{
			$model = $this->loadModel($id);
			$schoolId = $model->idSzkoly;
			$model->delete();

			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin','schoolId'=>$schoolId));
		}
		catch(Exception $e)
		{
			throw new CHttpException(404, 'Nie można usunąć rekordu. Obiekt może być nierozerwalnie połączony z innymi elementami w bazie.');
		}
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin($schoolId)
	{
		$schoolids = Yii::app()->user->getState('schoolId');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($schoolids) && $schoolId !== Yii::app()->user->getState('schoolId'))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$model = new Klasa('search');
		$model->unsetAttributes();
		$model->czyTestowa = 0;
		$model->searchSchoolIdFilter = $schoolId;

		if(isset($_GET['Klasa']))
			$model->attributes = $_GET['Klasa'];

		$schoolName = '';

		if(!isset($_GET['Klasa']))
			$schoolName = Szkola::model()->findByPk($schoolId)->nazwa;

		$this->render('admin', array(
			'model'=>$model,
			'schoolName'=>$schoolName,
			'schoolId'=>$schoolId
		));
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$model=Klasa::model()->with(array('admini', 'aktywneFirmy.uzytkownicy'))->findByPk($id);

		$schoolids = Yii::app()->user->getState('schoolId');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($schoolids) && $model->idSzkoly !== Yii::app()->user->getState('schoolId'))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$this->render('view',array(
			'model'=>$model,
		));
	}

	public function actionRegistrationStart($id)
	{
		$class = Klasa::model()->findByPk($id);

		if(isset($_POST['accept']))
		{
			$class->czasRozpoczeciaRejestracji = new CDbExpression('SYSDATE');
			$class->save(false);
			$registrationEndDate = date("Y-m-d H:i:s", strtotime('+'.ParametryGry::model()->find('"nazwa"=\'CZAS_NA_REJESTRACJE\'')->wartosc.' minutes',strtotime($class->getRegistrationTime())));
			Yii::app()->user->setFlash('registartionStarted','Rejestracja dla klasy '.$class->nazwa.' została rozpoczęta i będzie trwać do '.$registrationEndDate);
			$this->redirect(array('view', 'id'=>$id));
		}

		$this->render('registrationStart', array(
			'class'=>$class
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Klasa::model()->findByPk($id);

		if($model === null)
			throw new CHttpException(404, Yii::t('The requested page does not exist.'));

		$schoolids = Yii::app()->user->getState('schoolId');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($schoolids) && $model->idSzkoly !== Yii::app()->user->getState('schoolId'))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		return $model;
	}
}
